% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-yield.R
\name{ypr_plot_yield}
\alias{ypr_plot_yield}
\alias{ypr_plot_yield.default}
\alias{ypr_plot_yield.ypr_populations}
\title{Plot Yield by Capture}
\usage{
ypr_plot_yield(object, ...)

\method{ypr_plot_yield}{default}(
  object,
  y = "Yield",
  pi = seq(0, 1, length.out = 100),
  Ly = 0,
  harvest = TRUE,
  biomass = FALSE,
  u = harvest,
  plot_values = TRUE,
  ...
)

\method{ypr_plot_yield}{ypr_populations}(
  object,
  y = "Yield",
  pi = seq(0, 1, length.out = 100),
  Ly = 0,
  harvest = TRUE,
  biomass = FALSE,
  u = harvest,
  plot_values = TRUE,
  ...
)
}
\arguments{
\item{object}{The population or populations.}

\item{...}{Unused parameters.}

\item{y}{A string of the term on the y-axis.}

\item{pi}{A vector of probabilities of capture to calculate the yield for.}

\item{Ly}{The minimum length (trophy) fish to consider when calculating the
yield (cm).}

\item{harvest}{A flag specifying whether to calculate the yield for harvested
fish or captures.}

\item{biomass}{A flag specifying whether to calculate the yield in terms of
the biomass versus number of individuals.}

\item{u}{A flag specifying whether to plot the exploitation rate as opposed
to the capture rate.}

\item{plot_values}{A flag specifying whether to plot the actual and optimal
values.}
}
\value{
A ggplot2 object.
}
\description{
Plots the 'Yield', 'Age', 'Length', 'Weight', 'Effort', or 'YPUE' by the
annual interval capture/exploitation probability.
}
\section{Methods (by class)}{
\itemize{
\item \code{ypr_plot_yield(default)}: Plot Yield by Capture

\item \code{ypr_plot_yield(ypr_populations)}: Plot Yield by Capture

}}
\examples{
\dontrun{
ypr_plot_yield(ypr_populations(
  Rk = c(2.5, 4.6),
  Llo = c(0, 60)
),
plot_values = FALSE
) +
  ggplot2::facet_wrap(~Llo) +
  ggplot2::aes_string(group = "Rk", color = "Rk") +
  ggplot2::scale_color_manual(values = c("black", "blue"))

ypr_plot_yield(ypr_populations(Rk = c(2.5, 4.6), Llo = c(0, 60))) +
  ggplot2::facet_grid(Rk ~ Llo)
}

ypr_plot_yield(ypr_population())
}
\seealso{
Other populations: 
\code{\link{as_ypr_populations}()},
\code{\link{chilliwack_bt_05}},
\code{\link{ypr_populations_expand}()},
\code{\link{ypr_populations}()},
\code{\link{ypr_tabulate_sr}()},
\code{\link{ypr_tabulate_yields}()},
\code{\link{ypr_tabulate_yield}()}

Other yield: 
\code{\link{ypr_tabulate_yield}()},
\code{\link{ypr_yields}()},
\code{\link{ypr_yield}()}

Other plot: 
\code{\link{ypr_plot_biomass}()},
\code{\link{ypr_plot_fish}()},
\code{\link{ypr_plot_schedule}()},
\code{\link{ypr_plot_sr}()}
}
\concept{plot}
\concept{populations}
\concept{yield}
