% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.ycevo}
\alias{autoplot.ycevo}
\title{Plot the estimated discount functions and yield curves with ggplot2 or plotly}
\usage{
\method{autoplot}{ycevo}(
  object,
  est = c("both", "discount", "yield"),
  against = c("tau", "x", "both"),
  loess = TRUE,
  ...
)
}
\arguments{
\item{object}{A \link{ycevo} object}

\item{est}{String. Indicates which estimated values to plot: discount function, yield curve, or
both. Default is both.}

\item{against}{String. Indicates which variable to plot against, i.e. what is on the x axis.
Time-to-maturity \code{tau}, quotation date \code{x}, or both (requires package
\code{plotly}). If both, an interactive 3D plot is generated.}

\item{loess}{Logical. If TRUE, the returned discount functions and yield curves
are loess smoothed.}

\item{...}{Additional arguments required for generic consistency. Currently
not used. Warning: A misspelled argument will not raise an error. The
misspelled argument will be either disregarded, or the default value will
be applied if one exists.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object if only one dimension is specified in
\code{against}. A \code{\link[plotly:plot_ly]{plotly::plot_ly()}} object if \code{against} is set to both.
}
\description{
Plots the estimated discount functions and yield curves from a \code{\link[=ycevo]{ycevo()}} object with \code{ggplot2} or \code{plotly}.
}
\examples{
# Simulating bond data
bonds <- ycevo_data(n = 10)
\donttest{
# Estimation can take up to 30 seconds
res <- ycevo(bonds, x = lubridate::ymd("2023-03-01"))
# Plot
autoplot(res)
}

}
\seealso{
\code{\link[=ycevo]{ycevo()}}
}
