% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_as_xml_string.R
\name{list_as_xml_string}
\alias{list_as_xml_string}
\title{Convert a list to an xml string}
\usage{
list_as_xml_string(x, ...)
}
\arguments{
\item{x}{a list as returned by \code{\link[xml2:as_list]{xml2::as_list()}}}

\item{...}{reserved for future use}
}
\value{
a character string with the xml representation of the list
}
\description{
\code{list_to_xml_string} is fast and efficient way to convert a specific list to an xml string.
The preferred interface is to use \code{\link[=xml_fragment]{xml_fragment()}} and \code{\link[=xml_doc]{xml_doc()}} to create xml fragments.
}
\details{
This function is the working horse for turning \code{\link[=xml_fragment]{xml_fragment()}}, \code{\link[=xml_doc]{xml_doc()}} and list
object into \code{character} xml strings and \code{xml2::xml_document} objects.

The input list format is identical to the format returned by \code{\link[xml2:as_list]{xml2::as_list()}} function,
but much faster in generating an xml string from it. It writes the xml directly to a string buffer.

This function allows for easy conversion of R data structures
into xml format by creating the list structures in R and then converting them to xml.
The function can be used in tandem with \code{\link[xml2:as_list]{xml2::as_list()}} to convert R data structures.
}
\examples{
data <-
  list(
    study = list(
      person = list(
        name = "John Doe",
        age = "30"
      ),
      person = list(
        name = "Jane Doe",
        age = "25"
      )
    )
  )

list_as_xml_string(data)
if (require("xml2")){
  list_as_xml_document(data)
}

#note the xml_fragment function is more powerful to create lists

data <- xml_doc("study", id = "1") /
  frag(
    person = frag(
      name = "John Doe",
      age = "30"
    ),
    person = frag(
      name = "Jane Doe",
      age = "25"
    ),
    "This is a text node"
)

list_as_xml_string(data)
}
\seealso{
Other xml2: 
\code{\link{as_xml_nodeset}()},
\code{\link{list_as_xml_document}()}
}
\concept{xml2}
