% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{elem}
\alias{elem}
\title{add an element to an xmlbuilder object}
\usage{
elem(tag, text = NULL, ...)
}
\arguments{
\item{tag}{name of element}

\item{text}{text contents of element}

\item{...}{additional xml. attributes to be set}
}
\value{
an xmlbuilder object
}
\description{
add an element to an xmlbuilder object
}
\examples{
xb <- elem("homeless") /
  elem("person") / (
     elem("name","John Doe") +
     elem("age",35)
  ) +
  elem("person") /(
    elem("name","Jane Doe") +
    elem("age", 30)
  ) +
  elem("person") / (
    elem("name","Jim Doe") +
    elem("age", 25) +
    elem("address") / (
      elem("street", "123 Main St") +
      elem("city", "Anytown") +
      elem("state", "CA") +
      elem("zip", 12345)
    )
  )

print(xb)
xb$end()
xb$end()


doc <- xb |> xml2::as_xml_document()
doc |> as.character() |> cat()
}
