% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDfInitGene.R
\name{xegaGedeInitGene}
\alias{xegaGedeInitGene}
\title{Initialize a real-coded gene for grammar evolution}
\usage{
xegaGedeInitGene(lF)
}
\arguments{
\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
A real-coded gene (a named list):
        \itemize{
        \item \code{$evaluated}: FALSE. See package \code{xegaSelectGene}.
        \item \code{$evalFail}:  FALSE. Set by the error handler(s)
                                 of the Evaluation Functions
                                 in package \code{xegaSelectGene} 
                                 in the case of failure.
        \item \code{$fit}:       Fitness.
        \item \code{$gene1}:     A vector of reals.
        }
}
\description{
\code{xegaGedeInitGene()} generates a random real-coded gene 
             with a given length.
}
\details{
In the real-coded representation of 
         package \code{xegaDf}, \emph{gene} is at least a list with 
         \enumerate{
         \item \code{$evaluated}: Boolean. TRUE if the fitness is known.
         \item \code{$fit}:       The fitness of the genotype of 
                                 \code{$gene1}.        
         \item \code{$gene1}:     a real vector (the genotype).
         }
}
\examples{
xegaGedeInitGene(lFxegaDfGene)

}
\references{
Price, Kenneth V., Storn, Rainer M. and Lampinen, Jouni A. (2005)
The Differential Evolution Algorithm (Chapter 2), pp. 37-134. 
In: Differential Evolution. A Practical Approach to Global Optimization.
Springer, Berlin.
<doi:10.1007/3-540-31306-0>
}
\seealso{
Other Intialization: 
\code{\link{xegaDfInitGene}()}
}
\concept{Intialization}
