% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivationTrees.R
\name{filterANLid}
\alias{filterANLid}
\title{Filter an Attributed Node List (ANL) of a derivation tree by a symbol identifier.}
\usage{
filterANLid(ANL, nodeID = 1)
}
\arguments{
\item{ANL}{Attributed node list.}

\item{nodeID}{Integer. The identifier of a symbol.}
}
\value{
An attributed node list with nodes whose depths are in 
        \code{minb:maxb}. 
          Each node is represented as a list of the following attributes:
        \itemize{
        \item \code{Node$ID}:  Id in the symbol table ST.
        \item \code{Node$NonTerminal}:  Is the symbol a non-terminal?
        \item \code{Node$Pos}: Position in the trail.
        \item \code{Node$Depth}:  Depth of node.
        \item \code{Node$Rdepth}: Residual depth for expansion.
        \item \code{Node$subtreedepth}: Depth of subtree starting here.
        \item \code{Node$Index}:  R index of the node in the derivation tree.
                           Allows fast tree extraction and insertion.
        }
}
\description{
\code{filterANLid()} deletes all nodes whose \code{node$ID} does not match 
             \code{node$ID}.
             If the resulting list is empty, a list of length 0 is returned.
}
\details{
An attributed \code{node} has the following elements:
    \itemize{
        \item \code{$ID}:  Id in the symbol table \code{ST}.
        \item \code{$NonTerminal}:  Is the symbol a non-terminal?
        \item \code{$Pos}: Position in the trail.
        \item \code{$Depth}:  Depth of node.
        \item \code{$Rdepth}: Residual depth for expansion.
        \item \code{$subtreedepth}: Depth of subtree starting here.
        \item \code{$Index}:  R index of the node in the derivation tree.
                           Allows fast tree extraction and insertion.
       }

For the implementation of crossover and mutation, we expect a non-terminal symbol identifier.
}
\examples{
g<-compileBNF(booleanGrammar())
set.seed(111)
a<-randomDerivationTree(g$Start, g, maxdepth=10)
b<-treeANL(a, g$ST)
c<-filterANLid(b, nodeID=5)
d<-filterANLid(b, nodeID=6)
e<-filterANLid(b, nodeID=7)
f<-filterANLid(b, nodeID=8)

}
\seealso{
Other Access Tree Parts: 
\code{\link{filterANL}()},
\code{\link{treeANL}()},
\code{\link{treeChildren}()},
\code{\link{treeRoot}()}
}
\concept{Access Tree Parts}
