% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WSMed.R
\name{wsMed}
\alias{wsMed}
\title{Within-Subject Mediation Analysis (Two-Condition)}
\usage{
wsMed(
  data,
  M_C1,
  M_C2,
  Y_C1,
  Y_C2,
  C_C1 = NULL,
  C_C2 = NULL,
  C = NULL,
  C_type = NULL,
  W = NULL,
  W_type = NULL,
  MP = NULL,
  form = c("P", "CN", "CP", "PC"),
  Na = c("DE", "FIML", "MI"),
  alpha = 0.05,
  mi_args = list(),
  R = 20000L,
  bootstrap = 2000,
  boot_ci_type = "perc",
  iseed = 123,
  fixed.x = FALSE,
  ci_method = c("mc", "bootstrap", "both"),
  MCmethod = NULL,
  seed = 123,
  standardized = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{A \link[base:data.frame]{data.frame} containing the raw scores.}

\item{M_C1, M_C2}{Character vectors of mediator names under condition 1 and 2.}

\item{Y_C1, Y_C2}{Character scalars for the outcome under each condition.}

\item{C_C1, C_C2}{Character vectors of within-subject covariates (per condition).}

\item{C}{Character vector of between-subject covariates.}

\item{C_type}{Character; type of \code{C}: \code{"continuous"} or \code{"categorical"}.}

\item{W}{Character vector of moderators. Default \code{NULL}.}

\item{W_type}{Character; \code{"continuous"} or \code{"categorical"}.}

\item{MP}{Character vector identifying which regression paths are moderated
(for example, \code{"a1"}, \code{"b_1_2"}, \code{"cp"}).}

\item{form}{Model type: \code{"P"}, \code{"CN"}, \code{"CP"}, or \code{"PC"}.}

\item{Na}{Missing-data method: \code{"DE"}, \code{"FIML"}, or \code{"MI"}.}

\item{alpha}{Numeric vector in (0, 1); two-sided significance levels.}

\item{mi_args}{List of MI-specific controls:
\describe{
\item{\code{m}}{Number of imputations. Default 5.}
\item{\code{method_num}}{Imputation method for \code{mice()}.}
\item{\code{decomposition}}{Covariance-decomposition method
(\code{"eigen"}, \code{"chol"}, \code{"svd"}).}
\item{\code{pd}}{Logical; positive-definiteness check.}
\item{\code{tol}}{Tolerance for the positive-definiteness check.}
}}

\item{R}{Integer; number of Monte Carlo draws. Default \code{20000L}.}

\item{bootstrap}{Integer; number of bootstrap replicates (DE and FIML only).}

\item{boot_ci_type}{Character; bootstrap CI type: \code{"perc"}, \code{"bc"},
or \code{"bca.simple"}.}

\item{iseed, seed}{Integer seeds for bootstrap and Monte Carlo, respectively.}

\item{fixed.x}{Logical; passed to \pkg{lavaan}.}

\item{ci_method}{CI engine: \code{"bootstrap"} or \code{"mc"}.
If \code{NULL} (default) the choice is \code{"bootstrap"} for \code{Na = "DE"}
and \code{"mc"} otherwise.}

\item{MCmethod}{If \code{Na = "FIML"} and \code{ci_method = "mc"},
choose \code{"mc"} (default) or \code{"bootSD"}.}

\item{standardized}{Logical; if \code{TRUE}, return standardized effects. Default \code{FALSE}.}

\item{verbose}{Logical; print progress messages.}
}
\value{
An object of class \code{"wsMed"} with elements:
\describe{
\item{data}{Preprocessed data frame.}
\item{sem_model}{Generated \pkg{lavaan} syntax.}
\item{mc}{List with Monte Carlo draws, bootstrap tables (if any), and the fitted model.}
\item{moderation}{Conditional or moderated effect tables.}
\item{form,Na,alpha}{Analysis settings.}
\item{input_vars}{Names of all user-supplied variables.}
}
}
\description{
\code{wsMed()} fits a structural equation model (SEM) for two-condition
within-subject mediation. It can handle missing data (DE, FIML, MI) and
computes both unstandardized and standardized effects with bootstrap or
Monte Carlo confidence intervals.
}
\details{
Model structures:
\itemize{
\item \code{"P"}: parallel mediation
\item \code{"CN"}: chained (serial) mediation
\item \code{"CP"}: chained then parallel
\item \code{"PC"}: parallel then chained
}

Missing-data strategies:
\itemize{
\item \code{"DE"}: list-wise deletion
\item \code{"FIML"}: full-information maximum likelihood
\item \code{"MI"}: multiple imputation via \pkg{mice}
}

Confidence-interval engines:
\itemize{
\item Bootstrap: percentile, BC, or BCa (DE and FIML only)
\item Monte Carlo: draws via \pkg{semmcci} (all \code{Na} options)
}
For \code{Na = "FIML"}, you may choose \code{MCmethod = "mc"} (default) or
\code{"bootSD"} to add a finite-sample SD correction.

Workflow: (1) preprocess -> (2) generate SEM syntax -> (3) fit
-> (4) compute confidence intervals -> (5) optional: standardize estimates.
}
\examples{
data("example_data", package = "wsMed")
set.seed(123)
result <- wsMed(
  data = example_data,
  M_C1 = c("A2", "B2"),
  M_C2 = c("A1", "B1"),
  Y_C1 = "C1", Y_C2 = "C2",
  form = "P", Na = "DE"
)
print(result)

}
