% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string_interpolation.R
\name{strsplit_capture}
\alias{strsplit_capture}
\title{Split a string, keeping separator regions}
\usage{
strsplit_capture(
  x,
  split,
  ...,
  ignore.case = FALSE,
  fixed = FALSE,
  perl = FALSE,
  useBytes = FALSE
)
}
\arguments{
\item{x}{character string to split (length 1 vector)}

\item{split}{split pattern}

\item{...}{force later arguments to bind by name}

\item{ignore.case}{passed to \code{gregexpr}}

\item{fixed}{passed to \code{gregexpr}}

\item{perl}{passed to \code{gregexpr}}

\item{useBytes}{passed to \code{gregexpr}}
}
\value{
list of string segments annotated with is_sep.
}
\description{
Split a string, keeping separator regions
}
\examples{

strsplit_capture("x is .(x) and x+1 is .(x+1)", "\\\\.\\\\([^()]+\\\\)")

}
\seealso{
\code{\link{sinterp}}, \code{\link{si}}
}
