% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpipe.R
\name{dot_arrow}
\alias{dot_arrow}
\alias{\%.>\%}
\alias{\%>.\%}
\alias{\%.\%}
\title{Pipe operator ("dot arrow", "dot pipe" or "dot arrow pipe").}
\usage{
pipe_left_arg \%.>\% pipe_right_arg

pipe_left_arg \%>.\% pipe_right_arg

pipe_left_arg \%.\% pipe_right_arg
}
\arguments{
\item{pipe_left_arg}{left argument expression (substituted into .)}

\item{pipe_right_arg}{right argument expression (presumably including .)}
}
\value{
eval(\{ . <- pipe_left_arg; pipe_right_arg \};)
}
\description{
Defined as roughly : \code{a \%>.\% b} ~ \code{\{ . <- a; b \};}
(with visible .-side effects).
}
\details{
The pipe operator has a couple of special cases. First: if the right hand side is a name,
then we try to de-reference it and apply it as a function or surrogate function.

The pipe operator checks for and throws an exception for a number of "piped into
nothing cases" such as \code{5 \%.>\% sin()}, many of these checks can be turned
off by adding braces.

For some discussion, please see \url{https://win-vector.com/2017/07/07/in-praise-of-syntactic-sugar/}.
For some more examples, please see the package README \url{https://github.com/WinVector/wrapr}.
For formal documentation please see \url{https://github.com/WinVector/wrapr/blob/master/extras/wrapr_pipe.pdf}.
For a base-R step-debuggable pipe please try the Bizarro Pipe \url{https://win-vector.com/2017/01/29/using-the-bizarro-pipe-to-debug-magrittr-pipelines-in-r/}.
\code{\%>.\%} and \code{\%.>\%} are synonyms.

The dot arrow pipe has S3/S4 dispatch (please see \url{https://journal.r-project.org/archive/2018/RJ-2018-042/index.html}).
However as the right-hand side of the pipe is normally held unevaluated, we don't know the type except in special
cases (such as the rigth-hand side being referred to by a name or variable).  To force the evaluation of a pipe term,
simply wrap it in .().
}
\section{Functions}{
\itemize{
\item \code{pipe_left_arg \%.>\% pipe_right_arg}: dot arrow

\item \code{pipe_left_arg \%>.\% pipe_right_arg}: alias for dot arrow

\item \code{pipe_left_arg \%.\% pipe_right_arg}: alias for dot arrow

}}
\examples{

# both should be equal:
cos(exp(sin(4)))
4 \%.>\% sin(.) \%.>\% exp(.) \%.>\% cos(.)

f <- function() { sin }
# returns f() ignoring dot, not what we want
5 \%.>\% f()
# evaluates f() early then evaluates result with .-substitution rules
5 \%.>\% .(f())

}
