% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msg_wrap.R
\name{msg_wrap}
\alias{msg_wrap}
\title{Wraps a message before and/or after a function}
\usage{
msg_wrap(
  func,
  ...,
  before_func_msg = "",
  after_func_msg = "",
  print_func = print,
  use_msg = "both",
  print_return_var = FALSE
)
}
\arguments{
\item{func}{function.}

\item{...}{Additional arguments to be passed into the param func.}

\item{before_func_msg}{character.}

\item{after_func_msg}{character.}

\item{print_func}{function.  The default is print.  Can use related function like message.}

\item{use_msg}{character.  The default is "both".  Selects which messages to print in the function.  Use \code{before}, \code{after}, \code{both} or \code{none}.}

\item{print_return_var}{Boolean.  The default is FALSE.  Prints the output from the called func using the print argument from param print_func.}
}
\value{
Unknown.  The return type from the param func.
}
\description{
Wraps a message before and/or after a function
}
\examples{

numbers <- c(1,2,3,4,5)

answer <- msg_wrap(
                   sum,
                   numbers,
                   before_func_msg = "Currently summing the numbers",
                   after_func_msg = "Summing the numbers complete"
                   )

numbers_with_na <- c(1,2,3,NA,5)

answer_na_removed <- msg_wrap(
                              sum,
                              numbers,
                              na.rm = TRUE,
                              before_func_msg = "Sum with na.rm set to TRUE",
                              use_msg = "before"
                              )

numbers_to_sum <- c(10,20,30)

msg_wrap((function(x) sum(x[x\%\%2 == 1])),
         x = numbers_to_sum,
         before_func_msg = "Result from sum of odd numbers",
         use_msg = "before",
         print_return_var = TRUE
         )

}
