% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regrMultBy1or2point.R
\name{regrMultBy1or2point}
\alias{regrMultBy1or2point}
\title{Rescaling of multiple data-sets according to reference data using regression}
\usage{
regrMultBy1or2point(
  inDat,
  refLst,
  regrTo = c(1, 0.5),
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{inDat}{matrix or data.frame}

\item{refLst}{list of names existing in inDat (one group of names for each value in 'regrTo'), to be transformed in values precised in 'regTo'; if no matches to names of 'inDat' found, the 2 lowest and/or highest highest values will be chosen}

\item{regrTo}{(numeric,length=2) range (at scale 0-1) of target-values for mean of elements cited in 'refLst'}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
normalized matrix
}
\description{
\code{regrMultBy1or2point} regresses each col of matrix according to 'refLst'(describing rownames of inDat). 
If 'refLst' conatins 2 groups, the 1st group will be set to the 1st value of 'regrTo' (and the 2nd group of 'refLst' to the 2nd 'regtTo')
}
\examples{
set.seed(2016); dat2 <- round(cbind(1:50 +(1:50)*runif(50),2.2*(1:50) +rnorm(50,0,3)),1)
rownames(dat2) <- 1:nrow(dat2)
reg1 <- regrBy1or2point(dat2[,1],refLst=list(as.character(5:7),as.character(44:45)))
reg2 <- regrMultBy1or2point(dat2,refLst=list(as.character(5:7),as.character(44:45)))
plot(dat2[,1],reg2[,1])
identical(reg1,reg2[,1])
identical(dat2[,1],reg2[,1])
}
\seealso{
\code{\link{adjBy2ptReg}}, \code{\link{regrBy1or2point}}
}
