% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_functions.R
\name{read_analyze_wl}
\alias{read_analyze_wl}
\title{All-in-one import function for work loop files}
\usage{
read_analyze_wl(file_name, ...)
}
\arguments{
\item{file_name}{A .ddf file that contains data from a
single workloop experiment}

\item{...}{Additional arguments to be passed to \code{read_ddf()},
\code{select_cycles()},
or \code{analyze_workloop()}.}
}
\value{
The function returns a \code{list} of class \code{analyzed_workloop}
that provides instantaneous velocity, a smoothed velocity, and computes work,
 instantaneous power, and net power from a work loop experiment. All data are
 organized by the cycle number and important metadata are stored as
 Attributes.

Within the \code{list}, each entry is labeled by cycle and includes:
\item{Time}{Time, in sec}
\item{Position}{Length change of the muscle, corrected for gear ratio, in mm}
\item{Force}{Force, corrected for gear ratio, in mN}
\item{Stim}{When stimulation occurs, on a binary scale}
\item{Cycle}{Cycle ID, as a letter}
\item{Inst_velocity}{Instantaneous velocity, computed from \code{Position}
change, reported in meters/sec}
\item{Filt_velocity}{Instantaneous velocity, after low-pass filtering, again
 in meter/sec}
\item{Inst_Power}{Instantaneous power, a product of \code{Force} and
\code{Filt_velocity}, reported in J}
\item{Percent_of_Cycle}{The percent of that particular cycle which has
elapsed}

In addition, the following information is stored in the
\code{analyzed_workloop} object's attributes:
\item{stimulus_frequency}{Frequency at which stimulus pulses occurred}
\item{cycle_frequency}{Frequency of oscillations (assuming sine wave
trajectory)}
\item{total_cycles}{Total number of oscillatory cycles (assuming sine wave
trajectory) that the muscle experienced.}
\item{cycle_def}{Specifies what part of the cycle is understood as the
beginning and end. There are currently three options:
'lo' for L0-to-L0;
'p2p' for peak-to-peak; and
't2t' for trough-to-trough}
\item{amplitude}{Amplitude of length change (assuming sine wave
trajectory)}
\item{phase}{Phase of the oscillatory cycle (in percent) at which stimulation
occurred. Somewhat experimental, please use with caution}
\item{position_inverted}{Logical; whether position inversion has been
applied)}
\item{units}{The units of measurement for each column in the object after
running this function. See Warning}
\item{sample_frequency}{Frequency at which samples were collected}
\item{header}{Additional information from the header}
\item{units_table}{Units from each Channel of the original ddf file}
\item{protocol_table}{Protocol in tabular format; taken from the original
ddf file}
\item{stim_table}{Specific info on stimulus protocol; taken from the original
ddf file}
\item{stimulus_pulses}{Number of sequential pulses within a stimulation
train}
\item{stimulus_offset}{Timing offset at which stimulus began}
\item{gear_ratio}{Gear ratio applied by this function}
\item{file_id}{File name}
\item{mtime}{Time at which file was last modified}
\item{retained_cycles}{Which cycles were retained, as numerics}
\item{summary}{Simple table showing work (in J) and net power (in W) for each
 cycle}
}
\description{
\code{read_analyze_wl()} is an all-in-one function to read in a work loop
file, select cycles, and compute work and power output.
}
\details{
Please be careful with units! See Warnings below. This function
combines \code{read_ddf()} with \code{select_cycles()} and then ultimately
\code{analyze_workloop()} into one handy function.

As detailed in these three functions, possible arguments include: \cr
\code{cycle_def} - used to specify which part of the cycle is understood as
the beginning and end. There are currently three options: 'lo' for L0-to-L0;
'p2p' for peak-to-peak; and 't2t' for trough-to-trough \cr
\code{bworth_order} - Filter order for low-pass filtering of \code{Position}
 via \code{signal::butter} prior to finding peak lengths. Default: 2. \cr
\code{bworth_freq} - Critical frequency (scalar) for low-pass filtering of
\code{Position} via \code{signal::butter} prior to finding peak lengths.
Default: 0.05. \cr
\code{keep_cycles} - Which cycles should be retained. Default: 4:6. \cr
\code{GR} - Gear ratio. Default: 1. \cr
\code{M} - Velocity multiplier used to positivize velocity; should be either
-1 or 1. Default: -1. \cr
\code{vel_bf} - Critical frequency (scalar) for low-pass filtering of
velocity via \code{signal::butter}. Default: 0.05. \cr

The gear ratio (GR) and velocity multiplier (M) parameters can help correct
for issues related to the magnitude and sign of data collection. By
default, they are set to apply no gear ratio adjustment and to positivize
velocity. Instantaneous velocity is often noisy and the \code{vel_bf}
parameter allows for low-pass filtering of velocity data. See
\code{signal::butter()} and \code{signal::filtfilt()} for details of how
filtering is achieved.
}
\section{Warning}{

Most systems we have encountered record Position data in millimeters
and Force in millinewtons, and therefore this function assumes data are
recorded in those units. Through a series of internal conversions, this
function computes velocity in meters/sec, work in Joules, and power in
Watts. If your raw data do not originate in millimeters and millinewtons,
please transform your data accordingly and ignore what you see in the
attribute \code{units}.
}

\examples{

library(workloopR)

# import the workloop.ddf file included in workloopR and analyze with
# a gear ratio correction of 2 and cycle definition of peak-to-peak
wl_dat <- read_analyze_wl(system.file("extdata", "workloop.ddf",
                                      package = 'workloopR'),
                          phase_from_peak = TRUE,
                          GR = 2, cycle_def = "p2p")


}
\references{
Josephson RK. 1985. Mechanical Power output from Striated Muscle
 during Cyclic Contraction. Journal of Experimental Biology 114: 493-512.
}
\seealso{
\code{\link{read_ddf}},
\code{\link{select_cycles}}
\code{\link{analyze_workloop}}

Other data analyses: 
\code{\link{analyze_workloop}()},
\code{\link{isometric_timing}()},
\code{\link{read_analyze_wl_dir}()}

Other data import functions: 
\code{\link{as_muscle_stim}()},
\code{\link{get_wl_metadata}()},
\code{\link{read_analyze_wl_dir}()},
\code{\link{read_ddf_dir}()},
\code{\link{read_ddf}()}

Other workloop functions: 
\code{\link{analyze_workloop}()},
\code{\link{fix_GR}()},
\code{\link{get_wl_metadata}()},
\code{\link{invert_position}()},
\code{\link{read_analyze_wl_dir}()},
\code{\link{select_cycles}()},
\code{\link{summarize_wl_trials}()},
\code{\link{time_correct}()}
}
\author{
Vikram B. Baliga
}
\concept{data analyses}
\concept{data import functions}
\concept{workloop functions}
