% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_transformation_functions.R
\name{invert_position}
\alias{invert_position}
\title{Invert the position data}
\usage{
invert_position(x)
}
\arguments{
\item{x}{A \code{muscle_stim} object}
}
\value{
A \code{workloop} object with inverted position. The
\code{position_inverted} attribute is set to \code{TRUE} and all others are
retained.
}
\description{
Multiply instantaneous position by -1.
}
\details{
The \code{muscle_stim} object can be of any type, including
\code{workloop}, \code{twitch}, or \code{tetanus}.

If you have manually constructed the object via \code{as_muscle_stim()},
the \code{muscle_stim} object should have a column entitled \code{Position}.
Other columns and attributes are welcome and will be passed along unchanged.
}
\examples{

library(workloopR)

# import the workloop.ddf file included in workloopR
wl_dat <-read_ddf(system.file("extdata", "workloop.ddf",
                              package = 'workloopR'),
                  phase_from_peak = TRUE)

# invert the sign of Position
wl_fixed <- invert_position(wl_dat)

# quick check:
max(wl_fixed$Position) / min(wl_dat$Position) # -1

}
\seealso{
Other data transformations: 
\code{\link{fix_GR}()},
\code{\link{select_cycles}()}

Other workloop functions: 
\code{\link{analyze_workloop}()},
\code{\link{fix_GR}()},
\code{\link{get_wl_metadata}()},
\code{\link{read_analyze_wl_dir}()},
\code{\link{read_analyze_wl}()},
\code{\link{select_cycles}()},
\code{\link{summarize_wl_trials}()},
\code{\link{time_correct}()}

Other twitch functions: 
\code{\link{fix_GR}()},
\code{\link{isometric_timing}()}

Other tetanus functions: 
\code{\link{fix_GR}()}
}
\author{
Vikram B. Baliga
}
\concept{data transformations}
\concept{tetanus functions}
\concept{twitch functions}
\concept{workloop functions}
