% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwght2.R
\docType{data}
\name{bwght2}
\alias{bwght2}
\title{bwght2}
\format{
A data.frame with 1832 observations on 23 variables:
\itemize{
 \item \strong{mage:} mother's age, years
 \item \strong{meduc:} mother's educ, years
 \item \strong{monpre:} month prenatal care began
 \item \strong{npvis:} total number of prenatal visits
 \item \strong{fage:} father's age, years
 \item \strong{feduc:} father's educ, years
 \item \strong{bwght:} birth weight, grams
 \item \strong{omaps:} one minute apgar score
 \item \strong{fmaps:} five minute apgar score
 \item \strong{cigs:} avg cigarettes per day
 \item \strong{drink:} avg drinks per week
 \item \strong{lbw:} =1 if bwght <= 2000
 \item \strong{vlbw:} =1 if bwght <= 1500
 \item \strong{male:} =1 if baby male
 \item \strong{mwhte:} =1 if mother white
 \item \strong{mblck:} =1 if mother black
 \item \strong{moth:} =1 if mother is other
 \item \strong{fwhte:} =1 if father white
 \item \strong{fblck:} =1 if father black
 \item \strong{foth:} =1 if father is other
 \item \strong{lbwght:} log(bwght)
 \item \strong{magesq:} mage^2
 \item \strong{npvissq:} npvis^2
}
}
\source{
\url{https://www.cengage.com/cgi-wadsworth/course_products_wp.pl?fid=M20b&product_isbn_issn=9781111531041}
}
\usage{
data('bwght2')
}
\description{
Wooldridge Source: Dr. Zhehui Luo, a recent MSU Ph.D. in economics and Visiting Research Associate in the Department of Epidemiology at MSU, kindly provided these data. She obtained them from state files linking birth and infant death certificates, and from the National Center for Health Statistics natality and mortality data. Data loads lazily.
}
\section{Notes}{
 There are many possibilities with this data set. In addition to number of prenatal visits, smoking and alcohol consumption (during pregnancy) are included as explanatory variables. These can be added to equations of the kind found in Exercise C6.10. In addition, the one- and five-minute APGAR scores are included. These are measures of the well being of infants just after birth. An interesting feature of the score is that it is bounded between zero and 10, making a linear model less than ideal. Still, a linear model would be informative, and you might ask students about predicted values less than zero or greater than 10.

Used in Text: pages 184, 223
}

\examples{
 str(bwght2)
}
\keyword{datasets}
