% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasch_rescale.R
\name{rasch_rescale}
\alias{rasch_rescale}
\title{Rescale score from Rasch Analysis to range from 0 to 100}
\usage{
rasch_rescale(df, df_score, vars_id)
}
\arguments{
\item{df}{a data frame of individual survey data, where each row is an individual}

\item{df_score}{a tibble resulting from \code{rasch_model()} with the person abilities from the Rasch Model}

\item{vars_id}{a string with column name uniquely identifying individuals}
}
\value{
a tibble with the left join between \code{df} and \code{df_score} and new column "rescaled" with the rescaled person abilities, ranging from 0 to 100, and filter out any rows with an artificial minimum or maximum
}
\description{
Rescale score from Rasch Analysis to range from 0 to 100
}
\seealso{
Other rasch functions: 
\code{\link{rasch_DIF}()},
\code{\link{rasch_df_nest}()},
\code{\link{rasch_drop}()},
\code{\link{rasch_factor}()},
\code{\link{rasch_mds_children}()},
\code{\link{rasch_mds}()},
\code{\link{rasch_model_children}()},
\code{\link{rasch_model}()},
\code{\link{rasch_quality_children_print}()},
\code{\link{rasch_quality_children}()},
\code{\link{rasch_rawscore}()},
\code{\link{rasch_recode}()},
\code{\link{rasch_rescale_children}()},
\code{\link{rasch_split_age}()},
\code{\link{rasch_split}()},
\code{\link{rasch_testlet}()}
}
\concept{rasch functions}
