% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mab_impute.R
\name{imputation_precompute}
\alias{imputation_precompute}
\title{Precomputing Key Values for Outcome Imputation}
\usage{
imputation_precompute(data, whole_experiment, perfect_assignment, data_cols)
}
\arguments{
\item{data}{A data.frame, data.table, or tibble containing input data from the trial. This should be the results
of a traditional Randomized Controlled Trial (RCT). Any data.frames will be converted to tibbles internally.}

\item{whole_experiment}{Logical; if TRUE, uses all past experimental data for imputing outcomes.
If FALSE, uses only data available up to the current period. In large datasets or with a high number
of periods, setting this to FALSE can be more computationally intensive, though not a significant
contributor to total run time.}

\item{perfect_assignment}{Logical; if TRUE, assumes perfect information for treatment assignment
(i.e., all outcomes are observed regardless of the date).
If FALSE, hides outcomes not yet theoretically observed, based
on the dates treatments would have been assigned for each wave.
This is useful when simulating batch-based assignment where treatments were assigned
on a given day whether or not all the information from a prior batch was available and
you have exact dates treatments were assigned.}

\item{data_cols}{A named character vector containing the names of columns in \code{data} as strings:
\itemize{
\item \code{id_col}: Column in \code{data}; contains unique ID as a key.
\item \code{success_col}: Column in \code{data}; binary successes from the original experiment.
\item \code{condition_col}: Column in \code{data}; original treatment condition for each observation.
\item \code{date_col}: Column in \code{data}; contains original date of event/trial. Only necessary when assigning by "Date". Must be of type \code{Date}, not a character string.
\item \code{month_col}: Column in \code{data}; contains month of treatment. Only necessary when \code{time_unit = "Month"}, and when periods should be determined directly by
the calendar months instead of month based time periods. This column can be a string/factor variable with the month names or numeric with the month number. It can easily
be created from your \code{date_col} via \code{lubridate::month(data[[date_col]])} or \code{format(data[[date_col]], "\%m")}.
\item \code{success_date_col}: Column in \code{data}; contains original dates each success occurred. Only necessary when \code{perfect_assignment = FALSE}. Must be of type \code{Date}, not a character string.
\item \code{assignment_date_col}: Column in \code{data}; contains original dates treatments were assigned to observations. Only necessary when \code{perfect_assignment = FALSE}.
Used to simulate imperfect information on the part of researchers conducting an adaptive trial. Must be of type \code{Date}, not a character string.
}}
}
\value{
A named list containing:
\itemize{
\item \code{original_summary}: The tibble(s)/data.table(s) containing the probability of success for each
treatment block, at each period.
\item \code{dates_summary}: A tibble/data.table containing the average success date for
each treatment block at each treatment period.
}
}
\description{
Pre-computes key values required for the outcome imputation step of the Multi-Arm-Bandit
procedure. Calculates the probabilities of success for each treatment block (treatment arm + any blocking specified),
using the grouped means of the original experimental data. When \code{perfect_assignment} is FALSE, the average date of
success is calculated for each treatment block at every period.
}
\details{
\code{\link[=imputation_precompute]{imputation_precompute()}} is an optimization, meant to reduce the cost of calculating these variables
within the simulation loop. When \code{whole_experiment} is TRUE, \code{original_summary} is a single tibble/data.table,
and used through the simulation. When \code{whole_experiment} is FALSE, \code{original_summary} is a list of tibbles/data.tables,
each containing the cumulative probabilities of all periods up to the index i.

If \code{perfect_assignment} is FALSE, \code{dates_summary} is not calculated, and is NULL.

No covariates are used in the calculation, these are all simply grouped averages.
}
\keyword{internal}
