% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bagplot.R
\name{gg_bagplot}
\alias{gg_bagplot}
\title{Bagplot}
\usage{
gg_bagplot(data, var1, var2, color = "#00659e", show_points = FALSE, ...)
}
\arguments{
\item{data}{A data frame or matrix containing the data.}

\item{var1}{The name of the first variable to plot (a bare expression).}

\item{var2}{The name of the second variable to plot (a bare expression).}

\item{color}{The base color to use for the median. Other colors are generated
as a mixture of \code{color} with white.}

\item{show_points}{A logical argument indicating if a regular bagplot is required
(\code{FALSE}), or if a scatterplot in the same colors is required (\code{TRUE}).}

\item{...}{Other arguments are passed to the \code{\link[aplpack]{compute.bagplot}} function.}
}
\value{
A ggplot object showing a bagplot or scatterplot of the data.
}
\description{
Produces a bivariate bagplot. A bagplot is analagous to a
univariate boxplot, except it is in two dimensions. Like a boxplot, it
shows the median, a region containing 50\% of the observations, a region
showing the remaining observations other than outliers, and any outliers.
}
\examples{
gg_bagplot(n01, v1, v2)
gg_bagplot(n01, v1, v2, show_points = TRUE)
}
\references{
Rousseeuw, P. J., Ruts, I., & Tukey, J. W. (1999).
The bagplot: A bivariate boxplot. \emph{The American Statistician}, \bold{52}(4), 382–387.

Rob J Hyndman (2026) "That's weird: Anomaly detection using R", Section 5.6,
\url{https://OTexts.com/weird/}.
}
\seealso{
\code{\link[aplpack]{bagplot}}
}
\author{
Rob J Hyndman
}
