% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_leaders.R
\name{wnba_leaderstiles}
\alias{wnba_leaderstiles}
\title{\strong{Get WNBA Stats API Leaders Tiles}}
\usage{
wnba_leaderstiles(
  league_id = "10",
  game_scope = "Season",
  player_or_team = "Team",
  player_scope = "All Players",
  season = most_recent_wnba_season() - 1,
  season_type = "Regular Season",
  stat = "PTS",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{game_scope}{Game Scope - Season, Last 10, ,Yesterday, Finals}

\item{player_or_team}{Player or Team}

\item{player_scope}{Player Scope - All Players, Rookies}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs}

\item{stat}{Stat - PTS, REB, AST, FG_PCT, FT_PCT, FG3_PCT, STL, BLK}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: AllTimeSeasonHigh, LastSeasonHigh,
LeadersTiles, LowSeasonHigh,

\strong{LeadersTiles}\tabular{ll}{
   col_name \tab types \cr
   RANK \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_NAME \tab character \cr
   PTS \tab character \cr
}


\strong{AllTimeSeasonHigh}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_NAME \tab character \cr
   SEASON_YEAR \tab character \cr
   PTS \tab character \cr
}


\strong{LastSeasonHigh}\tabular{ll}{
   col_name \tab types \cr
   RANK \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_NAME \tab character \cr
   PTS \tab character \cr
}


\strong{LowSeasonHigh}\tabular{ll}{
   col_name \tab types \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_NAME \tab character \cr
   SEASON_YEAR \tab character \cr
   PTS \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Leaders Tiles}

\strong{Get WNBA Stats API Leaders Tiles}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{  wnba_leaderstiles(league_id = '10', player_or_team = "Player")
  wnba_leaderstiles(league_id = '10', player_or_team = "Team")
}\if{html}{\out{</div>}}
}
\author{
Saiem Gilani
}
\keyword{internal}
