% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unweightedweatherindices.R
\name{uwwi}
\alias{uwwi}
\title{Un-weighted Weather Indices}
\usage{
uwwi(y, weatherp)
}
\arguments{
\item{y}{A vector of yearly yield data for t years}

\item{weatherp}{Weekly weather data for t years as vector (total observations= number of years*number of weeks in each year)}
}
\value{
A vector of weather indices
}
\description{
Converts the weekly weather data into yearly un-weighted weather indices(simply averaged)
}
\examples{
data(Burdwanweather) #Weekly weather data for the rice growing season in Burdwan
data(Burdwanriceyield) #Yearly Yield data of rice  in Burdwan
wwi.maxtem<-wwi(Burdwanriceyield$burdwan,Burdwanweather$Max.Temperature)
wwi.maxtem
}
\references{
Jain, R. C., Agrawal, R., & Jha, M. P. (1980). Effect of climatic variables on      rice yield and its forecast. MAUSAM, 31(4), 591-596.
}
