% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_dictionary.R
\name{fill_dictionary}
\alias{fill_dictionary}
\title{Fill in the dictionary file based on the tidy data information}
\usage{
fill_dictionary(dict_path, data_dir)
}
\arguments{
\item{dict_path}{Path to the dictionary csvfile.}

\item{data_dir}{Path to the directory of the tidy R data objects. Defaults to data/}
}
\value{
A tibble data frame of dataset dictionary with an empty description column to be written.
}
\description{
Fill in the dictionary file based on the tidy data information
}
\examples{
\dontshow{
.old_wd <- setwd(tempdir())
}
\dontrun{
update_dictionary(dict_path = "data-raw/my-dictionary.csv", data = "data/")
}
\dontshow{
setwd(.old_wd)
}

}
