% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_list.R
\name{r_list}
\alias{r_list}
\title{List Production (From Variable Functions)}
\usage{
r_list(n, ..., rep.sep = "_")
}
\arguments{
\item{n}{The length to pass to the randomly generated vectors.}

\item{rep.sep}{A separator to use for repeated variable names.  For example
if the \code{\link[wakefield]{age}} is used three times
(\code{r_list(age, age, age)}), the name "Age" will be assigned to all three
vectors in the list.  The results in column names
\code{c("Age_1", "Age_2", "Age_3")}.  To turn of this behavior use
\code{rep.sep = NULL}.  This results in \code{c("Age", "Age", "Age")} for
vector names, leading to \code{c("Age", "Age.1", "Age.2")} if coerced to a
\code{\link[base]{data.frame}}.}

\item{\ldots}{A set of optionally named arguments.  Using \pkg{wakefield}
variable functions require no name or call parenthesis.}
}
\value{
Returns a named list of equal length vectors.
}
\description{
Produce a named \code{\link[base]{list}} that allows the user to lazily pass
unnamed \pkg{wakefield} variable functions (optionally, without call
parenthesis).
}
\examples{
r_list(
    n = 30,
    id,
    race,
    age,
    sex,
    hour,
    iq,
    height,
    died,
    Scoring = rnorm
)

r_list(
    n = 30,
    id,
    race,
    age(x = 8:14),
    Gender = sex,
    Time = hour,
    iq,
    height(mean=50, sd = 10),
    died,
    Scoring = rnorm
)
}
\references{
https://stackoverflow.com/a/29617983/1000343
}
\seealso{
\code{\link[wakefield]{r_data_frame}},
\code{\link[wakefield]{r_series}}
\code{\link[wakefield]{r_dummy}}
}
\author{
Josh O'Brien and Tyler Rinker <tyler.rinker@gmail.com>.
}
\keyword{list}
