% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candidates_get_by_office_state.R
\name{candidates_get_by_office_state}
\alias{candidates_get_by_office_state}
\title{Get candidates by the state in which they hold office}
\usage{
candidates_get_by_office_state(
  state_ids = NA,
  office_ids,
  election_years = lubridate::year(lubridate::today()),
  all = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{state_ids}{Optional: vector of state abbreviations. Default is \code{NA}, for national-level offices (e.g. US President and Vice President). For all other offices the \code{state_id} must be supplied.}

\item{office_ids}{Required: vector of office ids that candidates hold. See \code{\link{office_get_levels}} and \code{\link{office_get_offices_by_level}} for office ids.}

\item{election_years}{Optional: vector of election years in which the candidate held office. Default is the current year.}

\item{all}{Boolean: should all possible combinations of the variables be searched for, or just the exact combination of them in the order they are supplied?}

\item{verbose}{Should cases when no data is available be messaged?}
}
\value{
A dataframe of candidates and their attributes. If a given \code{state_id} + \code{office_id} + \code{election_year} combination returns no data, that row will be filled with \code{NA}s.
}
\description{
Get candidates by the state in which they hold office
}
\examples{
\dontrun{
candidates_get_by_office_state(
  state_ids = c(NA, "NY", "CA"),
  office_ids = c("1", "6"),
  verbose = TRUE
)
}
}
