% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_portfolio.R
\name{make_portfolio}
\alias{make_portfolio}
\title{Create Insurance Portfolio for Simulation}
\usage{
make_portfolio(data, cols = NULL)
}
\arguments{
\item{data}{A data.frame containing raw insurance portfolio data.}

\item{cols}{A named list with column mappings. The list should include:
\code{unique_id}, \code{client_id}, \code{duration},
\code{mortality}, \code{lapse}, \code{nar}, \code{rate}.}
}
\value{
A cleaned data.frame with standardized column names:
\code{unique_id}, \code{client_id}, \code{duration},
\code{mortality}, \code{lapse}, \code{nar}, \code{rate}.
}
\description{
This function standardizes and validates raw insurance portfolio data
to prepare it for simulation. It ensures all necessary fields are correctly
mapped and conform to required formats. If no column mapping is provided,
the user will be prompted interactively.
}
\examples{
make_portfolio(example_portfolio, cols = list(
  unique_id = "POL_ID",
  client_id = "CLIENT_ID",
  duration = "DURATION",
  mortality = "MORTALITY",
  lapse = "LAPSE",
  nar = "NAR",
  rate = "RATE"
))

}
