% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_longPutSyntheticStraddlePnL.R
\name{longPutSyntheticStraddlePnL}
\alias{longPutSyntheticStraddlePnL}
\title{Calculates per share Profit and Loss (PnL) at expiration for Long Put Synthetic Straddle Option Strategy and draws its Bar Plot displaying PnL in the Plots tab.}
\usage{
longPutSyntheticStraddlePnL(
  ST,
  X,
  P1,
  P2,
  S0,
  hl = 0,
  hu = 2,
  spot = spot,
  pl = pl,
  myData = myData,
  myTibble = myTibble,
  PnL = PnL
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X}{Strike Price or eXercise price.}

\item{P1}{Put Premium or Put Price paid for the first bought Put.}

\item{P2}{Put Premium or Put Price paid for the second bought Put.}

\item{S0}{Stock Price at which the stock is bought.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{spot}{Spot Price}

\item{pl}{Profit and Loss}

\item{myData}{Data frame}

\item{myTibble}{tibble}

\item{PnL}{Profit and Loss}
}
\value{
graph of the strategy
}
\description{
This volatility strategy (which is the same as a long straddle with the call replaced by a synthetic call) amounts to buying stock and buying two ATM (or the nearest ITM) put options with a strike price X. The outlook of investor or trader is neutral. This is capital gain strategy. This is a capital gain strategy (assuming S0 is  less than or equal to X and V0 is greater than (X minus S0)) (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Long Put Synthetic Straddle Option Strategy and draw its graph in the Plots tab.
}
\examples{
longPutSyntheticStraddlePnL(25,25,2,2,25.10)
longPutSyntheticStraddlePnL(40,40,5,5.2,40.2,hl=0.3,hu=1.7)
}
