% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableSchreirer.R
\name{tableSchreirer}
\alias{tableSchreirer}
\title{Create a table for the Scheirer-Ray-Hare test results}
\usage{
tableSchreirer(
  audioData,
  by = c(),
  measure = "duration",
  nameMeasure = c(),
  figureNumber = 1
)
}
\arguments{
\item{audioData}{A data.frame generated by the autoExtract() function.}

\item{by}{A character vector indicating the name of the factor(s).}

\item{measure}{Name of the dependent variable.}

\item{nameMeasure}{Optional string to rename the dependent variable in the output table. If no value is provided, the original variable name is displayed.}

\item{figureNumber}{Integer indicating the figure number, used to create the title for the table. Default corresponds to 1.}
}
\value{
HTML table showing Scheirer-Ray-Hare test results in APA formatting style.
}
\description{
Automatically generates an HTML table with the results for Scheirer-Ray-Hare test.
}
\examples{
tableSchreirer(testAudioData, by = c("Condition", "Dimension"), measure = "duration")

}
