% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparisonPlots.R
\name{comparisonPlots}
\alias{comparisonPlots}
\title{Create boxplots for extracted audio features}
\usage{
comparisonPlots(
  audioData,
  by = c(),
  measures = c("duration", "voice_breaks_percent", "RMS_env", "mean_loudness", "mean_F0",
    "sd_F0", "mean_entropy", "mean_HNR"),
  normalSig = 0.05,
  avoidNormalCheck = FALSE
)
}
\arguments{
\item{audioData}{A data.frame generated by the autoExtract() function.}

\item{by}{An optional character vector indicating column(s) from which the comparison groups are to be retrieved.}

\item{measures}{An optional character vector indicating the name of the variables to be plotted.}

\item{normalSig}{Set significance level to test for normality assumptions. Default corresponds to "0.05".}

\item{avoidNormalCheck}{Logical value forcing to avoid checking for normality. When defined as TRUE, it is assumed that the data is normally distributed. Default corresponds to FALSE.}
}
\value{
A list containing the generated boxplots.
}
\description{
Generates boxplots for each exracted feature. Plots can be split by experimental condition.
}
\examples{
comparisonPlots(testAudioData, by = "Condition")

}
