% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_regression.R
\name{check_regression}
\alias{check_regression}
\title{Check the fit of a regression model used to estimate EVPPI or EVSI}
\usage{
check_regression(
  x,
  pars = NULL,
  n = NULL,
  comparison = 1,
  outcome = "costs",
  plot = TRUE
)
}
\arguments{
\item{x}{Output from \code{\link{evppi}} or \code{\link{evsi}}. The argument \code{check=TRUE}
must have been used when calling \code{evppi} or \code{evsi}, to allow the regression model
objects from \code{gam} or \code{earth} to be preserved.  (This is not done by
default, since these objects can be large.).   \code{attr(x, "models")} contains these objects.}

\item{pars}{Parameter (or parameter group) whose EVPPI calculation is to be checked.
This should be in the \code{pars} component of the object returned by \code{\link{evppi}}.
Only relevant if \code{x} is the result of an \code{\link{evppi}} calculation.  By default,
the first calculation shown in \code{x} is checked.}

\item{n}{Sample size whose EVSI calculation is to be checked.
This should be in the \code{n} component of the object returned by \code{\link{evsi}}.
Only relevant if \code{x} is the result of an \code{\link{evsi}} calculation.}

\item{comparison}{Only relevant if there are more than two treatments in the decision model.
Different regression models are then used for the comparisons of different treatments
with the baseline treatment.
\code{comparison} is an integer identifying which of these models is checked.}

\item{outcome}{\code{"costs"} or \code{"effects"}.  Only relevant if \code{outputs} was
in cost-effectiveness format when
calling \code{evppi} or \code{evsi}, hence different regressions are used for costs and
effects.  By default, \code{outcome="costs"} is used, so that the regression
for costs is checked.}

\item{plot}{If \code{FALSE}, only numerical statistics are returned, and a plot is not made.}
}
\value{
Where possible, an appropriate statistic is returned that allows the regression
model to be compared with other regression models implemented using the same \code{method}
but with different assumptions.   For \code{method="gam"},
this is Akaike's information criterion (AIC).
For \code{method="earth"}, this is the generalised cross-validation statistic
\code{gcv}.    Currently not implemented for other methods.
}
\description{
Produces diagnostic plots and summaries of regression models used to estimate EVPPI or EVSI,
mainly in order to check that the residuals have mean zero.
}
\details{
For VoI estimation, the key thing we are looking for is that the residuals
have mean zero, hence that the mean of the model output is represented well by the
regression function of the model input parameters.  It should not matter if the
variance of the residuals is non-constant, or if the residuals are non-normally distributed.

Models produced with \code{method="gam"} are summarised using \code{\link[mgcv]{gam.check}}.

Models produced \code{method="earth"} are summarised using \code{\link[earth]{plot.earth}}.

For any regression model, if \code{fitted()} and \code{residuals()} methods are defined for those models,
then a histogram of the residuals and a scatterplot of residuals against fitted values is produced.
}
\examples{
pars <- c("p_side_effects_t1", "p_side_effects_t2")
evtest <- evppi(chemo_nb, chemo_pars, pars=pars, check=TRUE)
evtest
check_regression(evtest)

## with no interaction term 
evtest2 <- evppi(chemo_nb, chemo_pars, pars=pars, 
                gam_formula="s(p_side_effects_t1)+s(p_side_effects_t2)",
                check=TRUE)
evtest2
check_regression(evtest2)

## doesn't make much difference to the estimate
## fit is OK in either case

}
