% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot-method.R, R/ggplot.lmfit.R
\name{ggplot-method}
\alias{ggplot-method}
\alias{ggplot.lmfit}
\title{Plot functions}
\usage{
\method{ggplot}{lmfit}(data, mapping = NULL, ..., environment = parent.frame())
}
\arguments{
\item{data}{Either a numeric vector (to be used as x) or an object containing the data (e.g., a data frame).}

\item{mapping}{Either a numeric vector (to be used as y when data is numeric) or an aesthetic mapping
created with \code{ggplot2::aes()}. If \code{mapping} is missing and \code{data} is a data frame,
the default mapping \code{aes(x, y)} is used.}

\item{...}{Other arguments passed to ggplot2 components.}

\item{environment}{The environment in which to evaluate the plot. Defaults to \code{parent.frame()}.}
}
\value{
A ggplot object.
}
\description{
This function plots a linear model fit using ggplot2. It creates a scatter plot with a regression line,
and displays the regression equation along with the R² value.
}
\details{
When provided with two numeric vectors, the function treats them as x and y values, respectively,
constructs a data frame, and applies a default mapping. Alternatively, if a data frame is provided,
an aesthetic mapping (or default mapping) will be used.
}
\examples{
\dontrun{
  library(visa)
  # Using numeric vectors for x and y:
  ggplot.lmfit(1:10, 2:11)

  # Using a data frame:
  df <- data.frame(x = runif(10, 1, 10), y = runif(10, 2, 11) + 0.5)
  ggplot.lmfit(df, aes(x, y))
}

}
