% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentationHelper.R
\name{plotDoc}
\alias{plotDoc}
\title{Helper for consistent documentation of \code{plots}.}
\arguments{
\item{result}{A \verb{<summarised_result>} object.}

\item{x}{Column or estimate name that is used as x variable.}

\item{y}{Column or estimate name that is used as y variable.}

\item{width}{Bar width, as in \code{geom_col()} of the \code{ggplot2} package.}

\item{just}{Adjustment for column placement, as in \code{geom_col()} of the
\code{ggplot2} package.}

\item{facet}{Variables to facet by, a formula can be provided to specify
which variables should be used as rows and which ones as columns.}

\item{colour}{Columns to use to determine the colours.}

\item{group}{Columns to use to determine the group.}

\item{label}{Character vector with the columns to display interactively in
\code{plotly}.}

\item{style}{Visual theme to apply. Character, or \code{NULL}.
If a character, this may be either the name of a built-in style
(see \code{plotStyle()}), or a path to a \code{.yml} file that
defines a custom style. If \code{NULL}, the function will use the
explicit default style, unless a global style option is
set (see \code{setGlobalPlotOptions()}), or a \verb{_brand.yml} file is present
(in that order).
Refer to the package vignette on styles to learn more.}

\item{type}{Character string indicating the output plot format.
See \code{plotType()} for the list of supported plot types. If \code{type = NULL},
the function will use the global setting defined via \code{setGlobalPlotOptions()}
(if available); otherwise, a standard \code{ggplot2} plot is produced by default.}

\item{lower}{Estimate name for the lower quantile of the box.}

\item{middle}{Estimate name for the middle line of the box.}

\item{upper}{Estimate name for the upper quantile of the box.}

\item{line}{Whether to plot a line using \code{geom_line}.}

\item{point}{Whether to plot points using \code{geom_point}.}

\item{ribbon}{Whether to plot a ribbon using \code{geom_ribbon}.}

\item{ymin}{Lower limit of error bars, if provided is plot using
\code{geom_errorbar}.}

\item{ymax}{Upper limit of error bars, if provided is plot using
\code{geom_errorbar}.}

\item{position}{Position of bars, can be either \code{dodge} or \code{stack}}
}
\description{
Helper for consistent documentation of \code{plots}.
}
\keyword{internal}
