% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GC.content.R
\name{GC.content}
\alias{GC.content}
\title{GC content}
\usage{
GC.content(df.virus)
}
\arguments{
\item{df.virus}{data frame with seq_name and its DNA sequence.}
}
\value{
A data.frame with overall GC content as well as GC at first, second, and third codon positions of all DNA sequence from df.virus.
}
\description{
Calculates overall GC content as well as GC at first, second, and third codon positions.
}
\examples{
\dontshow{
file_path <- system.file("extdata", "sysdata.RData" ,package = "vhcub")
load(file = file_path)
}

\donttest{
# read DNA from fasta file
fasta <- fasta.read("virus.fasta", "host.fasta")
fasta.v <- fasta[[1]]
fasta.h <- fasta[[2]]
}

# Calculate GC content
gc.df <- GC.content(fasta.v)

}
\author{
Ali Mostafa Anwar \email{ali.mo.anwar@std.agr.cu.edu.eg} and Mohmed Soudy \email{MohmedSoudy2009@gmail.com}
}
