% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_mse.R
\name{lookup_estimates}
\alias{lookup_estimates}
\title{lookup_estimates}
\usage{
lookup_estimates(stratum_data_prepped, estimates_dir)
}
\arguments{
\item{stratum_data_prepped}{A data frame including all records in a stratum of interest.
The data frame should only include the source columns prefixed with \code{in_} and
all columns should only contain 1's and 0's.}

\item{estimates_dir}{Directory containing pre-calculated
estimates, if you would like to use pre-calculated results. Note, setting this
option forces the model specification parameters to be identical to those used
to calculate the pre-calculated estimates. Do not specify a file path If you
would like to use a custom model specification.}
}
\value{
A data frame with one column, \code{N}, indicating the results. If the
stratum was not found in the pre-calculated files, \code{N} will be \code{NA} and the
data frame will have one row. If the stratum was found in the pre-calculated
files, \code{N} will contain draws from the posterior distribution of the model
and the data frame will contain 1,000 rows.
}
\description{
Look up and read in existing estimates from pre-calculated files.
}
\examples{
\donttest{
in_A <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.45, 0.65))
in_B <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.5, 0.5))
in_C <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(0.75, 0.25))
in_D <- sample(c(0, 1), size = 100, replace = TRUE, prob = c(1, 0))

my_stratum <- tibble::tibble(in_A, in_B, in_C, in_D) \%>\%
    dplyr::mutate(rs = rowSums(.)) \%>\%
    dplyr::filter(rs >= 1) \%>\%
    dplyr::select(-rs)

lookup_estimates(stratum_data_prepped = my_stratum, estimates_dir = "path_to_estimates")

}
}
