% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixedLatitude.R
\name{fixedLatitude}
\alias{fixedLatitude}
\title{Download fixed-latitude equal-area grid}
\usage{
fixedLatitude(LatSpacing = 5, CellArea = "500000")
}
\arguments{
\item{LatSpacing}{Number of degrees desired between latitudinal bands}

\item{CellArea}{Desired target area of the cells in km^2 as a character string}
}
\value{
A simple features object
}
\description{
Download an equal-area grid of the world with fixed latitudinal spacing and variable longitudinal spacing.
}
\details{
Downloads an equal-area grid with fixed latitudinal spacing and variable longitudinal spacing. The distance between longitudinal borders of grids will adjust to the target area size within each band of latitude. The algorithm will adjust the area of the grids to ensure that the total surface of the globe is covered.
}
\examples{

# Download an equal area grid with 10 degree latitudinal spacing and 1,000,000 km^2 grids
# EqualArea<-fixedLatitude(LatSpacing=10,CellArea="1000000")

}
\author{
Andrew A. Zaffos
}
