% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.r
\encoding{UTF-8}
\name{encode_detail}
\alias{encode_detail}
\title{Encode detail "channel"}
\usage{
encode_detail(vl, field = NULL, type, aggregate = NULL, sort = NULL)
}
\arguments{
\item{vl}{Vega-Lite object created by \code{\link{vegalite}}}

\item{field}{single element character vector naming the column}

\item{type}{the encoded field’s type of measurement. This can be either a full type
name (\code{quantitative}, \code{temporal}, \code{ordinal}, and \code{nominal})
or an initial character of the type name (\code{Q}, \code{T}, \code{O}, \code{N}).
This property is case insensitive. If \code{auto} is used, the type will
be guessed (so you may want to actually specify it if you want consistency).}

\item{aggregate}{perform aggregaton on \code{field}. See
\href{http://vega.github.io/vega-lite/docs/aggregate.html}{Supported Aggregation Options} for
more info on valid operations. Leave \code{NULL} for no aggregation.}

\item{sort}{either one of \code{ascending}, \code{descending} or (for ordinal scales)
the result of a call to \code{\link{sort_def}}}
}
\description{
Grouping data is another important operation in visualizing data. For
aggregated plots, all encoded fields without aggregate functions are used as
grouping fields in the aggregation (similar to fields in GROUP BY in SQL).
For line and area marks, mapping a data field to color or shape channel will
group the lines and stacked areas by the field.\cr
\cr
detail channel allows providing an additional grouping field (level) for
grouping data in aggregation without mapping data to a specific visual
channel.
}
\note{
right now, \code{type} == "\code{auto}" just assume "\code{quantitative}". It
      will eventually get smarter, but you are better off specifying it.
}
\examples{
vegalite() \%>\%
  cell_size(200, 200) \%>\%
  add_data("https://vega.github.io/vega-editor/app/data/stocks.csv") \%>\%
  encode_x("date", "temporal") \%>\%
  encode_y("price", "quantitative") \%>\%
  encode_detail("symbol", "nominal") \%>\%
  mark_line()
}
\references{
\href{http://vega.github.io/vega-lite/docs/encoding.html}{Vega-Lite Encoding spec}
}

