% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_risk_curve}
\alias{plot_risk_curve}
\title{Plot the Risk Curve of Expected Infections}
\usage{
plot_risk_curve(
  disease = "Measles",
  kindergarten_size = 200,
  VE = NULL,
  r0_custom = NULL,
  save_data_to = NULL
)
}
\arguments{
\item{disease}{The disease to model. Default is "Measles".}

\item{kindergarten_size}{The size of the school cohort. Default is 200.}

\item{VE}{Vaccine effectiveness. If NULL (the default), a sensible default is
used for the chosen disease (e.g., 0.97 for Measles). A user-provided
value (0 to 1) will override the default.}

\item{r0_custom}{The basic reproduction number (R0) for a custom disease.
Required only if `disease` is "Custom".}

\item{save_data_to}{Optional file path to save the plot's underlying data.}
}
\value{
A ggplot object.
}
\description{
Plot the Risk Curve of Expected Infections
}
\examples{
# Plot with default VE for Pertussis (~0.85)
plot_risk_curve(disease = "Pertussis")
# Plot for a custom disease, requires VE and r0_custom
plot_risk_curve(disease = "Custom", VE = 0.85, r0_custom = 12)
}
