% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/themes.R
\name{panel_border}
\alias{panel_border}
\title{Add a panel border to a ggplot2 plot}
\usage{
panel_border(base_size = 12, base_color = NULL)
}
\arguments{
\item{base_size}{A numeric. Base size. Used to calculate line size and spacing.}

\item{base_color}{A character. Base color for lines.}
}
\description{
A simple \code{ggplot2} theme which replaces the axis lines with
a bordered panel.
}
\note{
This should be placed after the primary theme for the plot.
}
\examples{
library(ggplot2)

ggplot(datasets::mtcars, aes(x = wt, y = hp, color = as.factor(cyl))) +
  geom_point() +
  facet_wrap(~as.logical(am)) +
  theme_basic() +
  panel_border()
}
