% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centroid.R
\name{dist_to_centroids}
\alias{dist_to_centroids}
\title{Compute distances from each item to group centroids}
\usage{
dist_to_centroids(d, g, squared = FALSE)
}
\arguments{
\item{d}{A distance matrix object of class \code{dist}.}

\item{g}{A factor representing the groups of items in \code{d}.}

\item{squared}{If \code{TRUE}, return the squared distance to group
centroids.}
}
\value{
A data frame with distances to the group centroids:

\describe{
  \item{Item}{
    A character vector of item labels from the dist object, or an integer
    vector of item locations if labels are not present.}
  \item{CentroidGroup}{
    The group for which the centroid distance is given. The column type
    should match that of the argument g (the \code{unique} function is used
    to generate this column).}
  \item{CentroidDistance}{
    Inferred distance from the item to the centroid position of the
    indicated group.}}
}
\description{
Compute distances from each item to group centroids
}
\details{
This function computes the distance from each item to the centroid positions
of groups defined in the argument \code{g}.  This is accomplished without
determining the centroid positions directly; see the documentation for
\code{\link{dist_between_centroids}} for details on this procedure.

If the distance can't be represented in a Euclidean space, the
\code{CentroidDistance} is set to \code{NaN}.  See the documentation for
\code{\link{dist_between_centroids}} for further details.
}
