% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.unvs.med.R
\name{plot.unvs.med}
\alias{plot.unvs.med}
\title{Visualization of Mediation Effects}
\usage{
\method{plot}{unvs.med} (x, scale = "RD", type = c("PNDE", "TNIE"), ...)
}
\arguments{
\item{x}{a resulting object of class \code{"unvs.med"}
from function \code{\link{FormalEstmed}}.}

\item{scale}{a character variable of the effect scales. It may include more than one element.
The default is \code{"RD"}.}

\item{type}{a character variable of the effect types. The character can contain any types.
The default is \code{c("PNDE", "TNIE")}.}

\item{...}{additional parameters passed to "plot".}
}
\value{
No return value, called for making a plot.
}
\description{
This function is applied to the resulting object from function \code{\link{FormalEstmed}}
to make the plot of the mediation effects. The plot is shown in boxplot.
}
\details{
(1) For instance, for parameter \code{scale}, users can specify it as \code{"RD"}, \code{c("RD")},
\code{c("RD", "OR")}, \code{c("RD", "OR", "RR")}, etc. regardless of the order and quantity.
Besides, if \code{scale} equals to \code{"all"}, \code{"ALL"} or \code{"All"}, then effects on three scales will be output
(2) For \code{type}, the element is arbitrary, it may include any types of effects users are interested.
}
\examples{
\donttest{
# Running formal estimation
data(testdata)
med_model=glm(med~exp+C1+C2+C3, data=testdata, family=binomial) # Fitting mediator's model
out_model=lm(out~med*exp+C1+C2+C3, data=testdata) # Fitting outcome's model
r1 = FormalEstmed (med_model=med_model, out_model=out_model,
data=testdata, exposure = "exp") # Running formal estimation via bootstrapping

# Plot examples
plot(r1) # Plot of the default settings (plot PNED and TNDE on RD scales).
plot(r1,"OR") # Plot PNDE and TNIE on OR scales.
plot(r1,c("RD", "OR")) # Plot PNED and TNDE on RD and OR scales.
# Plot five types of the effects on RD and OR scales:
plot(r1,c("RD", "OR"), c("TE","PNDE", "TNDE", "PNIE", "TNIE"))
plot(r1,c("RD", "RR"), "all") # Plot all the effects on RD and RR scales.
plot(r1, scale=c("RD", "OR", "RR"), type="all") # Plot all the effects on all scales.
}

}
