% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/karim.R
\name{sp_line}
\alias{sp_line}
\title{create an spatiallineobject from 2 points}
\usage{
sp_line(
  Y_coords,
  X_coords,
  ID = "ID",
  proj4 = "+proj=longlat +datum=WGS84 +no_defs",
  export = FALSE,
  runDir
)
}
\arguments{
\item{Y_coords}{Y/lat coordinates}

\item{X_coords}{X/lon coordinates}

\item{ID}{id of line}

\item{proj4}{projection}

\item{export}{write shafefile default = F}

\item{runDir}{\code{character} runtime folder}
}
\description{
create an spatiallineobject from 2 points, optional export as shapefile
}
\examples{
\dontrun{
## creating sp spatial point object
line <- sp_line(c(8.770367,8.771161,8.771536),
                c(50.815172,50.814743,50.814875),
                runDir=tempdir())

## plot it
plot(line)
}
}
