% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.twomodeClustering.R
\name{summary.twomodeClustering}
\alias{summary.twomodeClustering}
\title{Summary method for twomodeClustering objects}
\usage{
\method{summary}{twomodeClustering}(object, ...)
}
\arguments{
\item{object}{An object of class 'twomodeClustering'.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
An object of class summary.twomodeClustering with components:
\describe{
\item{matrixDim}{Named integer vector: rows, cols}
\item{nRowClusters}{Number of row clusters}
\item{nColClusters}{Number of column clusters}
\item{rowClusterSizes}{Table of row cluster sizes}
\item{colClusterSizes}{Table of column cluster sizes}
\item{biclusters}{Data frame with bicluster summaries (if myMatrix present), possibly merged with validation per-block stats}
\item{fitness}{Best fitness value if available, else NA}
\item{validationGlobal}{List with r2, fStat, pValue, dfModel, dfResid, pMonteCarlo (if present), or NULL}
\item{nSigBlocks}{Number of BH-significant blocks at 0.05 if available, else NULL}
\item{rowContribution}{Data frame with total effectSS per row cluster (if available), else NULL}
\item{colContribution}{Data frame with total effectSS per column cluster (if available), else NULL}
}
}
\description{
Creates a summary of a twomodeClustering object, including matrix dimensions,
cluster sizes, fitness, optional bicluster summaries (if matrix available),
and optional validation highlights (if validation is present).
}
