% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitorFactory.R
\name{monitorFactory}
\alias{monitorFactory}
\title{Two mode clustering monitoring function factory for GA progress}
\usage{
monitorFactory(interval = 100)
}
\arguments{
\item{interval}{An integer specifying the interval for printing progress updates.
Default is 100 (prints every 100 generations).}
}
\value{
A monitoring function that can be used with GA. The returned function takes a GA object
and prints progress information at the specified interval.
}
\description{
Creates a monitoring function that prints the current generation and the best fitness score
to the console at specified intervals. Intended for use as a \code{monitor} function in GA runs.
}
\examples{
# Create monitor that prints every 100 generations (default)
monitor <- monitorFactory()
# ga(..., monitor = monitor)

# Create monitor that prints every 50 generations
monitor <- monitorFactory(50)
# ga(..., monitor = monitor)

}
