% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CfFuncs.R
\name{xnpv}
\alias{xnpv}
\title{Net Present Value of an irregular cashflow (NPV)}
\usage{
xnpv(i, cf, d, tau = NULL, comp_freq = 1)
}
\arguments{
\item{i}{The rate used to discount the cashflow}

\item{cf}{The cashflow}

\item{d}{The dates when each cashflow occurs. Same length as the cashflow. Only used if tau is NULL. Assumes act/365 fractions}

\item{tau}{The year fractions when each cashflow occurs. Same length as the cashflow}

\item{comp_freq}{The compounding frequency used. Most relevant cases are 1 for yearly, 2 twice a year, 4 quarterly, 12 monthly, 0 no compounding, Inf continuous}
}
\description{
Net Present Value of an irregular cashflow (NPV)
}
\examples{
xnpv(i = 0.01, cf = c(-1, 0.5, 0.9), d = as.Date(c("2015-01-01", "2015-02-15", "2015-04-10")))
}
