% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{append_samples}
\alias{append_samples}
\title{Append samples}
\usage{
append_samples(x, ...)
}
\arguments{
\item{x}{A genomic data container to combine with others}

\item{...}{Additional genomic data containers to combine

  Each argument should be a genomic data object such as a SummarizedExperiment,
  SingleCellExperiment, SpatialExperiment, or Seurat object (provided that
  the appropriate method extensions are available). You may also provide a list
  of such objects.

  When row-binding, features (e.g., genes) are matched by name, and any missing
  features will be filled with NA or zero as appropriate for the container.

  When column-binding, samples (e.g., cells) are matched by position, so all objects
  must have the same number of features. To match by value, not position, see mutate-joins.}
}
\value{
A combined genomic object
}
\description{
Append multiple samples or datasets together, combining their data while preserving sample-specific information.
}
\examples{

print("combined_data <- append_samples(sample1, sample2, .id = \"sample\")")

}
