% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_tteICE.R
\name{print.tteICE}
\alias{print.tteICE}
\title{Print method for 'tteICE' objects}
\usage{
\method{print}{tteICE}(x, digits = 4, ...)
}
\arguments{
\item{x}{A fitted object returned by the function \code{tteICE}, \code{surv.tteICE}, or \code{scr.tteICE}.}

\item{digits}{The digits of the results}

\item{...}{Other arguments in function \code{\link{print.default}}}
}
\value{
Print the summary of a tteICE object
}
\description{
This function summarizes the results
}
\examples{
## load data
data(bmt)
bmt = transform(bmt, d4=d2+d3)
A = as.numeric(bmt$group>1)
bmt$A = A

## print the results
fit1 = surv.tteICE(A, bmt$t2, bmt$d4, "composite")
print(fit1)

fit2 = scr.tteICE(A, bmt$t1, bmt$d1, bmt$t2, bmt$d2, "composite")
print(fit2, digits=2)

library(survival)
fit3 = tteICE(Surv(t2, d4, type = "mstate")~A,
              data=bmt, strategy="composite", method='eff')
print(fit3, digits=3)

}
\seealso{
\code{\link[tteICE]{surv.tteICE}},
\code{\link[tteICE]{scr.tteICE}},
\code{\link[tteICE]{tteICE}}
}
