% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_qes.R
\name{ts_fil_qes}
\alias{ts_fil_qes}
\title{Quadratic Exponential Smoothing}
\usage{
ts_fil_qes(gamma = FALSE)
}
\arguments{
\item{gamma}{If TRUE, enables the gamma seasonality component.}
}
\value{
A \code{ts_fil_qes} object.
}
\description{
Double/triple exponential smoothing capturing level, trend,
and optionally seasonality components.
}
\examples{
# time series with noise
library(daltoolbox)
data(tsd)
tsd$y[9] <- 2*tsd$y[9]

# filter
filter <- ts_fil_qes()
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# plot
plot_ts_pred(y=tsd$y, yadj=y)
}
\references{
\itemize{
\item P. R. Winters (1960). Forecasting sales by exponentially weighted moving
averages. Management Science.
}
}
