% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{tsfilter.cgarch.estimate}
\alias{tsfilter.cgarch.estimate}
\alias{tsfilter}
\alias{tsfilter.dcc.estimate}
\alias{tsfilter.gogarch.estimate}
\title{Model Filtering}
\usage{
\method{tsfilter}{cgarch.estimate}(
  object,
  y = NULL,
  newxreg = NULL,
  update = TRUE,
  cond_mean = NULL,
  ...
)

\method{tsfilter}{dcc.estimate}(
  object,
  y = NULL,
  newxreg = NULL,
  update = TRUE,
  cond_mean = NULL,
  ...
)

\method{tsfilter}{gogarch.estimate}(object, y = NULL, newxreg = NULL, cond_mean = NULL, ...)
}
\arguments{
\item{object}{an object of class \dQuote{cgarch.estimate} or \dQuote{dcc.estimate}.}

\item{y}{an xts matrix of new values to filter.}

\item{newxreg}{not used in these models.}

\item{update}{whether to update certain values using the most recent information
less than the new data (see details).}

\item{cond_mean}{an optional matrix of the filtered conditional mean values.}

\item{...}{additional arguments for future expansion.}
}
\value{
A \dQuote{cgarch.estimate} or \dQuote{dcc.estimate} object with updated
information. All values in the object are updated with the exception of the hessian
and scores which remain at their estimation set values.
}
\description{
Filters new data based on an already estimated model.
}
\details{
The method filters new data and updates the object with this new information
so that it can be called recursively as new data arrives. The \dQuote{update} argument
allows values such as the intercept matrices and transformation estimates (for the
\dQuote{spd} and \dQuote{empirical} methods) in the dynamic case, and the constant
correlation in the constant case, to use information up to and include time T, where
T is the time stamp just preceding the new y timestamps. In this way, the filter
method can be called recursively and the user can selectively choose to either use the
updating scheme or use the original estimated values. Whatever the case, this ensures
that there is no look-ahead bias when filtering new information.
}
