% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_output.R
\name{generate_output}
\alias{generate_output}
\title{Generate output in specified format (e.g., xlsx, html, pdf, word)}
\usage{
generate_output(data, path, ..., format = c("xlsx", "html", "pdf", "word"))
}
\arguments{
\item{data}{Preferably a \code{tsg} class object for best results. A data frame, tibble, and list are also supported.}

\item{path}{File path to save the output.}

\item{...}{Additional arguments passed to specific format functions.}

\item{format}{Output format. One of \code{"xlsx"}, \code{"html"}, \code{"pdf"}, or \code{"word"}.}
}
\value{
Generates and saves the output file in the specified format at the given path.
}
\description{
Generate output in specified format (e.g., xlsx, html, pdf, word)
}
\examples{
#' # Generate an xlsx file from a tsg object
data <- generate_frequency(dplyr::starwars, sex)

dir_to <- tempdir()
generate_output(
  data,
  file.path(dir_to, "starwars_frequency.xlsx"),
  format = "xlsx"
)

unlink(file.path(dir_to, "starwars_frequency.xlsx"))

}
