% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{kmest}
\alias{kmest}
\title{Kaplan-Meier Estimates of Survival Curve}
\usage{
kmest(
  data,
  stratum = "",
  time = "time",
  time2 = "",
  event = "event",
  weight = "",
  conftype = "log-log",
  conflev = 0.95,
  keep_censor = FALSE
)
}
\arguments{
\item{data}{The input data frame that contains the following variables:
\itemize{
\item \code{stratum}: The stratum.
\item \code{time}: The follow-up time for right censored data, or
the left end of each interval for counting process data.
\item \code{time2}: The right end of each interval for counting process
data. Intervals are assumed to be open on the left
and closed on the right, and event indicates whether an event
occurred at the right end of each interval.
\item \code{event}: The event indicator, 1=event, 0=no event.
\item \code{weight}: The weight for each observation.
}}

\item{stratum}{The name(s) of the stratum variable(s) in the input data.}

\item{time}{The name of the time variable or the left end of each
interval for counting process data in the input data.}

\item{time2}{The name of the right end of each interval for counting
process data in the input data.}

\item{event}{The name of the event variable in the input data.}

\item{weight}{The name of the weight variable in the input data.}

\item{conftype}{The type of the confidence interval. One of "none",
"plain", "log", "log-log" (the default), or "arcsin".
The arcsin option bases the intervals on asin(sqrt(survival)).}

\item{conflev}{The level of the two-sided confidence interval for
the survival probabilities. Defaults to 0.95.}

\item{keep_censor}{Whether to retain the censoring time in the output
data frame.}
}
\value{
A data frame with the following variables:
\itemize{
\item \code{size}: The number of subjects in the stratum.
\item \code{time}: The event time.
\item \code{nrisk}: The number of subjects at risk.
\item \code{nevent}: The number of subjects having the event.
\item \code{ncensor}: The number of censored subjects.
\item \code{surv}: The Kaplan-Meier estimate of the survival probability.
\item \code{sesurv}: The standard error of the estimated survival
probability based on the Greendwood formula.
\item \code{lower}: The lower bound of confidence interval if requested.
\item \code{upper}: The upper bound of confidence interval if requested.
\item \code{conflev}: The level of confidence interval if requested.
\item \code{conftype}: The type of confidence interval if requested.
\item \code{stratum}: The stratum.
}
}
\description{
Obtains the Kaplan-Meier estimates of the survival curve.
}
\examples{

kmest(data = aml, stratum = "x", time = "time", event = "status")

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
