% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_source_priors_params.R
\name{two_source_priors_params}
\alias{two_source_priors_params}
\title{Adjust Bayesian priors - Two Source Trophic Position}
\usage{
two_source_priors_params(
  a = NULL,
  b = NULL,
  c1 = NULL,
  c1_sigma = NULL,
  c2 = NULL,
  c2_sigma = NULL,
  n1 = NULL,
  n1_sigma = NULL,
  n2 = NULL,
  n2_sigma = NULL,
  dn = NULL,
  dn_sigma = NULL,
  tp_lb = NULL,
  tp_ub = NULL,
  sigma_lb = NULL,
  sigma_ub = NULL,
  bp = FALSE
)
}
\arguments{
\item{a}{(\eqn{\alpha}) exponent of the random variable for beta distribution.
Defaults to \code{1}. See beta distribution for more information.}

\item{b}{(\eqn{\beta}) shape parameter for beta distribution.
Defaults to \code{1}. See beta distribution for more information.}

\item{c1}{mean (\eqn{\mu}) prior for the mean of the first \eqn{\delta^{13}}C
baseline. Defaults to \code{-21}.}

\item{c1_sigma}{variance (\eqn{\sigma})for the mean of the first
\eqn{\delta^{13}}C baseline. Defaults to \code{1}.}

\item{c2}{mean (\eqn{\mu}) prior for or the mean of the
second \eqn{\delta^{13}}C baseline. Defaults to \code{-26}.}

\item{c2_sigma}{variance (\eqn{\sigma})for the mean of the first
\eqn{\delta^{13}}C baseline. Defaults to \code{1}.}

\item{n1}{mean (\eqn{\mu}) prior for the mean of the first \eqn{\delta^{15}}N
baseline. Defaults to \code{8}.}

\item{n1_sigma}{variance (\eqn{\sigma})for the mean of the first
\eqn{\delta^{15}}N baseline. Defaults to \code{1}.}

\item{n2}{mean (\eqn{\mu}) prior for or the mean of the
second \eqn{\delta^{15}}N baseline. Defaults to \code{9.5}.}

\item{n2_sigma}{variance (\eqn{\sigma}) for the mean of the second
\eqn{\delta^{15}}N  baseline. Defaults to \code{1}.}

\item{dn}{mean (\eqn{\mu}) prior value for \eqn{\Delta}N. Defaults to \code{3.4}.}

\item{dn_sigma}{variance (\eqn{\sigma}) for \eqn{\delta^{15}}N.
Defaults to \code{0.25}.}

\item{tp_lb}{lower bound for priors for trophic position. Defaults to \code{2}.}

\item{tp_ub}{upper bound for priors for  trophic position. Defaults to \code{10}.}

\item{sigma_lb}{lower bound for priors for \eqn{\sigma}. Defaults to \code{0}.}

\item{sigma_ub}{upper bound for priors for \eqn{\sigma}. Defaults to \code{10}.}

\item{bp}{logical value that controls whether informed priors are
supplied to the model for both \eqn{\delta^{15}}N and
\eqn{\delta^{15}}C baselines. Default is \code{FALSE} meaning the model will
use uninformed priors, however, the supplied \code{data.frame} needs values
for both \eqn{\delta^{15}}N and \eqn{\delta^{15}}C baseline
(\code{c1}, \code{c2}, \code{n1}, and \code{n2}).}
}
\value{
\code{stanvars} object to be used with \code{brms()} call.
}
\description{
Adjust priors for two source trophic position model derived from \href{https://esajournals.onlinelibrary.wiley.com/doi/full/10.1890/0012-9658\%282002\%29083\%5B0703\%3AUSITET\%5D2.0.CO\%3B2}{Post 2002}.
}
\details{
We will use the following equations from \href{https://esajournals.onlinelibrary.wiley.com/doi/full/10.1890/0012-9658\%282002\%29083\%5B0703\%3AUSITET\%5D2.0.CO\%3B2}{Post 2002}:

\enumerate{
\item \deqn{\delta^{13}C_c = \alpha * (\delta ^{13}C_1 - \delta ^{13}C_2) +
\delta ^{13}C_2}
\item \deqn{\delta^{15}N = \Delta N \times (tp - \lambda_1) +
n_1 \times \alpha + n_2 \times (1 - \alpha)}
\item \deqn{\delta^{15}N = \Delta N \times (tp - (\lambda_1 \times \alpha +
\lambda_2 \times (1 - \alpha))) + n_1 \times \alpha +
n_2 \times (1 - \alpha)}
}

\itemize{
\item The random exponent (\eqn{\alpha}; \code{a})
and shape parameters (\eqn{\beta}; \code{b}) for \eqn{\alpha}. This prior
assumes a beta distribution.
\item The mean (\code{c1}; \eqn{\mu}) and variance (\code{c1_sigma}; \eqn{\sigma}) of
the mean for the first \eqn{\delta^{13}C} for a given baseline.
This prior assumes a normal distributions.
\item The mean (\code{c2};\eqn{\mu}) and variance (\code{c2_sigma}; \eqn{\sigma}) of
the mean for the second \eqn{\delta^{13}C} for a given baseline.
This prior assumes a normal distributions.
\item The mean (\code{n1}; \eqn{\mu}) and variance (\code{n1_sigma}; \eqn{\sigma}) of
the mean for the first \eqn{\delta^{15}N} for a given baseline.
This prior assumes a normal distributions.
\item The mean (\code{n2};\eqn{\mu}) and variance (\code{n2_sigma}; \eqn{\sigma}) of
the mean for the second \eqn{\delta^{15}}N for a given baseline.
This prior assumes a normal distributions.
\item The mean (\code{dn}; \eqn{\mu}) and variance (\code{dn_sigma}; \eqn{\sigma}) of
\eqn{\Delta}N (i.e, trophic enrichment factor).
This prior assumes a normal distributions.
\item The lower (\code{tp_lb}) and upper (\code{tp_ub}) bounds for priors for
trophic position. This prior assumes a uniform distributions.
\item The lower (\code{sigma_lb}) and upper (\code{sigma_ub}) bounds for
variance (\eqn{\sigma}). This prior assumes a uniform distributions.
}
}
\examples{
two_source_priors_params()
}
\seealso{
\code{\link[=two_source_priors]{two_source_priors()}}, \code{\link[=two_source_model]{two_source_model()}}, and \code{\link[brms:brms-package]{brms::brms()}}
}
