% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{sda}
\alias{sda}
\title{Filter track for speed, distance and angle.}
\usage{
sda(x, smax, ang = c(15, 25), distlim = c(2.5, 5), pre = NULL)
}
\arguments{
\item{x}{trip object}

\item{smax}{maximum speed, in km/h}

\item{ang}{minimum turning angle/s in degrees}

\item{distlim}{maximum step lengths in km}

\item{pre}{include this filter in the removal}
}
\value{
logical vector, with \code{FALSE} values where the tests failed
}
\description{
Create a filter index of a track for "bad" points with a
combination of speed, distance and angle tests.
}
\details{
This is an independent  implementation from that in the
package argosfilter by Freitas 2008.
}
\references{
Freitas, C., Lydersen, C., Fedak, M. A. and Kovacs,
K. M. (2008), A simple new algorithm to filter marine mammal Argos
locations. Marine Mammal Science, 24: 315?V325. doi:
10.1111/j.1748-7692.2007.00180.x
}
