% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_sBoundsPh2.R
\name{sBoundsPh2}
\alias{sBoundsPh2}
\title{Critical boundaries for the secondary endpoint in the partially hierarchical group sequential design}
\usage{
sBoundsPh2(
  alpha,
  alpha0,
  t0,
  t1,
  tc0 = t0,
  tc1 = t1,
  rho = 0,
  iuse0 = 1,
  iuse1h = 1,
  iuse1t = 1,
  phi0 = rep(1, length(alpha)),
  phi1h = rep(1, length(alpha)),
  phi1t = rep(1, length(alpha))
)
}
\arguments{
\item{alpha}{a value of overall type I error rate}

\item{alpha0}{a value of the type I error rate for testing H0}

\item{t0}{a vector of information times for H0}

\item{t1}{a vector of information times for H1}

\item{tc0}{a vector of calendar times for H0}

\item{tc1}{a vector of calendar times for H1}

\item{rho}{a value of the correlation between the test statistics for H0 and H1.}

\item{iuse0}{a value of the type of error spending function for H0, ranging from 1 to 4}

\item{iuse1h}{a value of the type of error spending function for H1 first half, ranging from 1 to 4}

\item{iuse1t}{a value of the type of error spending function for H1 second half, ranging from 1 to 4}

\item{phi0}{a value of the parameter of error spending function for H0}

\item{phi1h}{a value of the parameter of error spending function for H1 first half}

\item{phi1t}{a value of the parameter of error spending function for H1 second half}
}
\value{
a list of two vectors: \code{bd} critical boundaries, \code{er} error spent until each stage
}
\description{
This function computes the critical boundaries for the secondary endpoint in the partially hierarchical group sequential design.
}
\examples{
alpha <- 0.05
alpha0 <- 0.03
iuse0 <- 4
iuse1h <- 4
iuse1t <- 4
phi0 <- -4
phi1h <- 1
phi1t <- 1
tc0 <- c(3,6,9,12)
tc1 <- c(6,12,18,24)
t0 <- c(0.3,0.6,0.9,1)
t1 <- (1:4)/4
rho <- 0
sBoundsPh2(alpha, alpha0,
    t0, t1, tc0, tc1,
    rho, iuse0, iuse1h, iuse1t,
    phi0, phi1h, phi1t)
alpha <-  0.025
alpha0 <- 0.01
iuse0 <- 4
iuse1 <- 4
phi0 <- -4
phi1 <- -4
tc0 <- c(3,6,9,12,18)
tc1 <- c(6,12,18,36)
t0 <- (1:5)/5
t1 <- (1:4)/4
rho <- 0.0;
sBoundsPh2(alpha, alpha0,
    t0, t1, tc0, tc1,
    rho, iuse0, iuse1h=iuse1, iuse1t=iuse1,
    phi0, phi1h=phi1, phi1t=phi1)
}
\references{
Gou, J. (2023). Trigger strategy in repeated tests on multiple hypotheses. \emph{Statistics in Biopharmaceutical Research}, 15(1), 133-140.
Gou, J. (2022). Sample size optimization and initial allocation of the significance levels in group sequential trials with multiple endpoints. \emph{Biometrical Journal}, 64(2), 301-311.
}
\author{
Jiangtao Gou
}
